<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package topwrench
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo('charset'); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<link rel="preload" href="<?php echo get_template_directory_uri();?>/assets/fonts/DMSans-Bold.woff2" as="font" type="font/woff2" crossorigin>
	<link rel="preload" href="<?php echo get_template_directory_uri();?>/assets/fonts/DMSans-Regular.woff2" as="font" type="font/woff2" crossorigin>

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<?php wp_body_open(); ?>
	<div id="page" class="site">
		<!-- Header Start -->
		<header id="masthead" class="site-header">
			<div class="container">
				<div class="row">
					<div class="col-lg-2">
						<div class="site-branding">
							<?php the_custom_logo(); ?>
						</div>
					</div>
					<div class="col-lg-10">
						<div class="header-menu">
							<nav id="site-navigation" class="main-navigation">
								<button class="menu-toggle" type="button" name="Hamburger Menu" aria-controls="primary-menu" aria-expanded="false">
									<span></span>
									<span></span>
									<span></span>
								</button>
								<div class="header-mobile-menu">
									<?php
									wp_nav_menu(
										array(
											'theme_location' => 'menu-1',
											'menu_id'        => 'primary-menu',
										)
									);
									?>
								</div>
							</nav>

							<div class="header-btn for-des">
								<a href="javascript:void(0)" class="sec-btn white-btn" title="Learn More">Learn More</a>
							</div>
						</div>
					</div>
				</div>
			</div>
		</header>
		<!-- Header End -->