<?php

/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package topwrench
 */

?>

<footer id="colophon" class="site-footer">
	<div class="sec-wp">
		<div class="top-footer">
			<div class="container">
				<div class="row">
					<div class="col-lg-4">
						<div class="footer-about">
							<div class="footer-logo">
								<div class="site-branding">
									<?php the_custom_logo(); ?>
								</div>
							</div>
							<div class="footer-logo-about-text white-text">
								<p>Unveiling Excellence: Dive into the World of [Your Mechanic Mastery] At [Your Mechanic Mastery], we transform curiosity into capability, passion into proficiency. Discover the heart of automotive expertise with us.</p>
							</div>
							<div class="social-media">
								<ul>
									<li><a href="javascript:void(0)" title="Follow On Facebook"><i class="fab fa-facebook-f"></i></a></li>
									<li><a href="javascript:void(0)" title="Follow On Instagram"><i class="fab fa-instagram"></i></a></li>
									<li><a href="javascript:void(0)" title="Follow On Linkdin"><i class="fab fa-linkedin-in"></i></a></li>
								</ul>
							</div>
						</div>
					</div>
					<div class="col-lg-4">
						<div class="contact-info-wp">
							<div class="contact-info-title white-text">
								<h5 class="h5-title">Contact Us</h5>
							</div>
							<div class="contact-info-box">
								<ul>
									<li><a href="javascript:void(0)" title="36276 Daugherty Terrace, New Lavernborough, MN 77406-2788">
											<span class="contact-info-icon"><i class="fas fa-map-marker-alt"></i></span>
											<span class="contact-info-icon-text">36276 Daugherty Terrace, New Lavernborough, MN 77406-2788</span>
										</a>
									</li>
									<li><a href="tel:15203225578" title="+1520 322 5578">
											<span class="contact-info-icon"><i class="fas fa-phone-alt"></i></span>
											<span class="contact-info-icon-text h6-title callus">+1520 322 5578</span>
										</a>
									</li>
									<li><a href="mailto:topwrenchnetwork@gmail.com" title="topwrenchnetwork@gmail.com">
											<span class="contact-info-icon"><i class="fas fa-envelope"></i></span>
											<span class="contact-info-icon-text">topwrenchnetwork@gmail.com</span>
										</a>
									</li>
								</ul>
							</div>
						</div>
					</div>
					<div class="col-lg-4">
						<div class="footer-form-wp">
							<div class="footer-form-title white-text">
								<h5 class="h5-title">Get In Touch</h5>
							</div>
							<div class="contact-form-box">
								<?php
								echo do_shortcode('[contact-form-7 id="4c7fc6d" title="Contact form 1"]');
								?>
							</div>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col-lg-12">
						<div class="footer-menu">
							<?php
							wp_nav_menu(
								array(
									'theme_location' => 'footer-menu',
									// 'menu_id'        => 'menu-footer-menu',
								)
							);
							?>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="footer-bottom-box">
			<div class="container">
				<div class="row align-items-center">
					<div class="col-12">
						<div class="footer-bottom-text">
							<div class="copy-right">
								<p>© 2024 Lean Revisions</p>
							</div>
							<div class="footer-bottom-link">
								<?php
								wp_nav_menu(
									array(
										'theme_location' => 'policy-menu',
									)
								);
								?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</footer>
</div><!-- #page -->

<!-- Scroll To Top Start -->
<button type="button" id="scrollToTop" class="scrolltop" name="Back To Top"><i class="fas fa-angle-double-up"></i></button>
<!-- Scroll To Top End -->

<?php wp_footer(); ?>

</body>

</html>